/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

/**
 * @author Bruckardt
 * 
 */
public class GTableModel extends AbstractTableModel {
    // --------------------------------------------------------
    private List aListe = null;

    /*
     * (Kein Javadoc)
     * 
     * @see javax.swing.table.DefaultTableModel#getColumnName(int)
     */
    public String getColumnName(int inpColumn) {
        return null;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see javax.swing.table.DefaultTableModel#isCellEditable(int, int)
     */
    public boolean isCellEditable(int inpRow, int inpColumn) {
        return false;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return (aListe == null) ? 0 : aListe.size();
    }

    public Object getValueAt(int inpRowIndex, int inpColumnIndex) {
        if (inpColumnIndex == 0 && inpRowIndex >= 0
                && inpRowIndex < getRowCount()) {
            return aListe.get(inpRowIndex);
        }
        return null;
    }

    public Object getObjectAtRow(int inpRowIndex) {
        if (inpRowIndex >= 0 && inpRowIndex < getRowCount()) {
            return aListe.get(inpRowIndex);
        }
        return null;
    }

    public GAufnahmeIF getAufnahmeAtRow(int inpRowIndex) {
        Object tmpObject = getObjectAtRow(inpRowIndex);
        if (tmpObject instanceof GAufnahmeContainer) {
            tmpObject = ((GAufnahmeContainer) tmpObject).getAufnahme();
        }
        if (tmpObject instanceof GAufnahmeIF) {
            return (GAufnahmeIF) tmpObject;
        }
        return null;
    }

    public int getAnzahlAufnahmen() {
        return getRowCount();
    }

    public List getListe() {
        if (aListe == null) {
            aListe = new ArrayList();
        }
        return aListe;
    }

    public void setListe(List inpListe) {
        aListe = inpListe;
    }

    public void clear() {
        if (aListe != null) {
            aListe.clear();
        }
    }

    public void addRow(Object inpObject) {
        getListe().add(inpObject);
    }

    public void addRow(int index, Object inpObject) {
        getListe().add(index, inpObject);
    }

    private void adjustAufnahmen1(GAufnahmeContainer inpDeleted, int row) {
        try {
            GAufnahmeContainer tmpContainer = inpDeleted;
            // der Container selbst wurde gelscht
            if (!tmpContainer.hasChildren()) {
                return; // nothing to do :-))
            }
            boolean expand = false;
            // expandierte children einklappen
            if (tmpContainer.isExpanded()) {
                expand = true;
                List tmpList2 = tmpContainer.getDoubles();
                int anz = (tmpList2 == null) ? 0 : tmpList2.size();
                int k;
                for (k = 0; k < anz; k++) {
                    GAufnahmeContainer tmpDouble = (GAufnahmeContainer) tmpList2
                            .get(0);
                    removeRow(tmpDouble);
                    tmpContainer.removeDouble(tmpDouble);
                } // for i
            }
            List tmpList = tmpContainer.getChildren();
            int anzc = (tmpList == null) ? 0 : tmpList.size();
            // mindestens 1 child sollte da sein
            GAufnahmeIF tmpAufnahme2 = (GAufnahmeIF) tmpList.get(0);
            GAufnahmeContainer tmpContainer2 = new GAufnahmeContainer(
                    tmpAufnahme2);
            addRow(row++, tmpContainer2);
            for (int j = 1; j < anzc; j++) {
                GAufnahmeIF tmpAufnahme3 = (GAufnahmeIF) tmpList.get(j);
                tmpContainer2.addChild(tmpAufnahme3);
                if (expand) { // wieder aufklappen
                    GAufnahmeContainer tmpDouble = new GAufnahmeContainer(
                            tmpAufnahme3);
                    addRow(row++, tmpDouble);
                    tmpContainer.addDouble(tmpDouble);
                }
            } // for j
            fireTableDataChanged();
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    private void adjustAufnahmen2(GAufnahmeContainer inpDeleted, int row) {
        try {
            int anza = getRowCount();
            List tmpList = getListe();
            for (int i = 0; i < anza; i++) {
                Object tmpObject = tmpList.get(i);
                if (!(tmpObject instanceof GAufnahmeContainer)) {
                    continue;
                }
                GAufnahmeContainer tmpContainer = (GAufnahmeContainer) tmpObject;
                // children durchsuchen
                GAufnahmeIF tmpAufnahme = inpDeleted.getAufnahme();
                List tmpList2 = tmpContainer.getChildren();
                boolean del = tmpList2.remove(tmpAufnahme);
                if (!del) {
                    continue; // nicht in diesem Container
                }
                // expandierte children einklappen
                if (tmpContainer.isExpanded()) {
                    tmpList2 = tmpContainer.getDoubles();
                    int anz = (tmpList2 == null) ? 0 : tmpList2.size();
                    int k;
                    for (k = 0; k < anz; k++) {
                        GAufnahmeContainer tmpDouble = (GAufnahmeContainer) tmpList
                                .get(0);
                        removeRow(tmpDouble);
                        tmpContainer.removeDouble(tmpDouble);
                    } // for i
                }
                break;
            } // for i
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    private void adjustAufnahmen(GAufnahmeContainer inpDeleted, int row) {
        try {
            if (inpDeleted.isExpandedDouble()) {
                adjustAufnahmen2(inpDeleted, row);
            } else {
                adjustAufnahmen1(inpDeleted, row);
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    public Object removeRow(int inpRow) {
        if (inpRow >= 0 && inpRow < getRowCount()) {
            Object tmpObject = getListe().remove(inpRow);
            if (tmpObject instanceof GAufnahmeContainer) {
                adjustAufnahmen((GAufnahmeContainer) tmpObject, inpRow);
            }
        }
        return null;
    }

    public Object removeRow(Object inpObject) {
        if (inpObject != null) {
            getListe().remove(inpObject);
        }
        return null;
    }
}
